﻿$MinimumDriftSpeed = 50; # Minimum speed in km/h to maintain. Driving below that speed will reset score
$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset
$GoodDriftScore = 4000; # Value to be reached to execute action on good drift score
$MinimumDriftScore = 10; # Minimum drift score required
$RealTimeDriftScore = 1;

# Actions to do on new personal best drift lap.
CatchEvent OnDriftPB( $userName ) # Player event
	globalRcm( langEngine( "%{main_newdriftpb}%" , GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("DriftScore") . " ^3pts!") );
EndCatchEvent

# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.
CatchEvent OnDriftLap( $userName ) # Player event
	globalMsg( langEngine( "%{main_driftlap}%" , GetCurrentPlayerVar("NickName"), GetCurrentPlayerVar("DriftScore") ) );
EndCatchEvent

# Message to get on end of each drift.
CatchEvent OnDriftScore( $userName ) # Player event
	privMsg( langEngine( "%{main_ondriftscore}%" , GetCurrentPlayerVar("DriftScore"), GetCurrentPlayerVar("LastDriftScore") ) );
EndCatchEvent


CatchEvent OnGoodDrift( $userName ) # Player event
	privMsg( langEngine( "%{main_ongooddrift}%" ,GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("LastDriftScore") ) );
EndCatchEvent

# Actions to do at end of lap if MinimumDriftScore is not achieved.
CatchEvent OnDriftTooLow( $userName ) # Player event
	privMsg( langEngine( "%{main_drifttolow}%" ,GetCurrentPlayerVar("NickName") ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );
EndCatchEvent

Lang "EN"
	main_newdriftpb = "{0}^3 made new PB: ^7{1} ^3pts!";
	main_driftlap = "{0} ^3drifted to ^7{1} ^3pts";
	main_ondriftscore = "Score: ^7{0} ^3{1}";
	main_ongooddrift = "{0} ^3made excellent drift: ^7{1} ^3pts";
	main_drifttolow = "{0}^3 disqualified";
EndLang

Lang "FR"
	main_newdriftpb = "{0}^3 réalise un nouveau PB: ^7{1} ^3pts!";
	main_driftlap = "{0} ^3réalise ^7{1} ^3pts de drift";
	main_ondriftscore = "Score: ^7{0} ^3{1}";
	main_ongooddrift = "{0} ^3réalise un drift excellent : ^7{1} ^3pts";
	main_drifttolow = "{0}^3 disqualifié";
EndLang

Lang "NL" # NL Language made by $!N-Tim (emit-nl)
 main_newdriftpb = "{0}^3 heeft een nieuwe PB: ^7{1} ^3pts!";
 main_driftlap = "{0} ^3heeft ^7{1} ^3pts gedrift";
 main_ondriftscore = "Score: ^7{0} ^3{1}";
 main_ongooddrift = "{0} ^3maakte een geweldige drift: ^7{1} ^3pts";
 main_drifttolow = "{0}^3 is gediskwalificeerd";
EndLang
Lang "NO" #Translated by Carlos/DenonForce14
    main_newdriftpb = "{0}^3 gjorde en ny banerekord: ^7{1} ^3poeng!";
    main_driftlap = "{0} ^3driftet til ^7{1} ^3poeng";
    main_ondriftscore = "Score: ^7{0} ^3{1}";
    main_ongooddrift = "{0} ^3gjorde en utrolig drift: ^7{1} ^3poeng";
    main_drifttolow = "{0}^3 diskvalifisert";
EndLang


